﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class SkyscraperModel : BuildingModel
{
    public float StoreyHeightMultiplier { get; private set; }

    public SkyscraperModel()
    {

    }

    public override bool Parse(XElement modelElem)
    {
        try
        {
            if (base.Parse(modelElem))
            {
                StoreyHeightMultiplier = Convert.ToSingle(modelElem.Attribute("StoreyHeightMultiplier").Value);
                return true;
            }

            else
            {
                Debug.LogError("ERROR: Failed to parse base BuildingModel in SkyscraperModel, returning false.");
            }

            return false;
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing skyscraper model. The exception is: " + ex);
            return false;
        }
    }
}